/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.router;

import filenet.vw.api.VWException;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskBaseNode;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTablePanel;
import filenet.vw.apps.taskman.VWTaskXMLHandler;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.router.VWRouterAdminPropertyPanel;
import filenet.vw.apps.taskman.router.VWRouterNode;
import filenet.vw.apps.taskman.router.VWRouterTableModel;
import filenet.vw.apps.taskman.router.resources.VWResource;
import filenet.vw.base.VWString;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VWRouterAdminNode
extends VWTaskBaseNode {
    private static boolean m_bRouterMigrateMsgDisplayed = false;
    private VWRouterAdminPropertyPanel m_propertyPanel = null;
    private VWRouterTableModel m_tableModel = null;
    private VWTaskTablePanel m_tablePanel = null;
    private Hashtable m_savedRouters = new Hashtable();
    private Integer m_rmiPort = new Integer(32771);
    protected static final ImageIcon nodeIcon32 = VWImageLoader.createImageIcon("routeradmin_32.gif");
    protected static final ImageIcon nodeIcon16 = VWImageLoader.createImageIcon("routeradmin_16.gif");
    public static final String XML_NODE_NAME = "RouterAdminNode";

    public VWRouterAdminNode(String propertiesPath) throws Exception {
        super(VWResource.ProcessRouters, propertiesPath, "TaskManager.Router", 4);
        this.setIcon32(nodeIcon32);
        this.setIcon16(nodeIcon16);
        this.setExpandAtStartup(true);
        this.fromXML(this.getXMLHandler());
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel = new VWRouterAdminPropertyPanel(this);
            this.m_tableModel = new VWRouterTableModel(this);
            this.m_tablePanel = new VWTaskTablePanel(this.m_tableModel);
            this.getContentPane().setPropertyPanel(this.m_propertyPanel);
            this.getContentPane().setTablePanel(this.m_tablePanel);
        }
        this.addSavedRouters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_propertyPanel.refresh();
            this.m_tableModel.refresh();
        }
        Class<VWRouterAdminNode> clazz = VWRouterAdminNode.class;
        synchronized (VWRouterAdminNode.class) {
            if (this.getChildCount() > 0 && !m_bRouterMigrateMsgDisplayed) {
                VWString msg = new VWString("filenet.vw.apps.taskman.router.VWRouterAdminNode.MigrateRoutersMsg", "Process Routers should be migrated to the Content Engine as Process Engine Connection points.  After they have been migrated the Process Routers should be deleted.");
                VWString title = new VWString("filenet.vw.apps.taskman.router.VWRouterAdminNode.RouterMigrationTitle", "Process Routers Detected");
                VWMessageDialog.showOptionDialog((Frame)VWTaskCore.getInstance().getMainFrame(), msg.toString(), title.toString(), 2, 40, "taskmanager/router_migration.htm", UIManager.getIcon("OptionPane.informationIcon"), 500, 140);
                m_bRouterMigrateMsgDisplayed = true;
            } else if (this.getChildCount() == 0) {
                this.delete();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean getAutoStartEnabled() {
        return false;
    }

    public void setRegistryPort(Integer port) {
        this.m_rmiPort = port;
        this.removeAllChildren();
        this.addSavedRouters();
        this.refresh();
        this.reload();
    }

    public Integer getRegistryPort() {
        return this.m_rmiPort;
    }

    public String toString() {
        return "RouterAdmin Node toString() result";
    }

    public void displayHelp() {
        VWHelp.displayPage(VWHelp.Help_Process_TaskManager + "router.htm");
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.DELETE) == 0) {
                this.delete();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.displayHelp();
            }
        }
        catch (Exception ex) {
            this.displayError(ex);
        }
    }

    public String[] getActions() {
        String[] actions = new String[]{VWTaskActionCommand.DELETE, "Add Separator", VWTaskActionCommand.HELP};
        return actions;
    }

    public boolean isActionEnabled(String actionCMD) {
        return true;
    }

    public boolean showPropertyIcon() {
        return true;
    }

    protected VWRouterNode getRouterNode(String name) {
        VWRouterNode routerNode = null;
        VWRouterNode tmp = null;
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            tmp = (VWRouterNode)e.nextElement();
            if (VWStringUtils.compare(tmp.getName(), name) != 0) continue;
            routerNode = tmp;
            break;
        }
        return routerNode;
    }

    public void addRouterNode(VWRouterNode routerNode) {
        this.add(routerNode, 1);
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_tableModel.refresh();
        }
    }

    protected VWRouterNode[] getRouterNodes() {
        VWRouterNode[] routers = null;
        int childCount = this.getChildCount();
        if (childCount > 0) {
            routers = new VWRouterNode[childCount];
            Enumeration<TreeNode> e = this.children();
            for (int i = 0; i < childCount; ++i) {
                routers[i] = (VWRouterNode)e.nextElement();
            }
        }
        return routers;
    }

    private void newSavedRouter(VWRouterNode node) {
        Hashtable<String, VWRouterNode> routerDef = (Hashtable<String, VWRouterNode>)this.m_savedRouters.get(this.m_rmiPort.toString());
        if (routerDef == null) {
            routerDef = new Hashtable<String, VWRouterNode>();
            this.m_savedRouters.put(this.m_rmiPort.toString(), routerDef);
        }
        routerDef.put(node.getName(), node);
    }

    public void removeSavedRouter(VWRouterNode node) {
        Hashtable routerDef = (Hashtable)this.m_savedRouters.get(this.m_rmiPort.toString());
        if (routerDef != null && routerDef.containsKey(node.getName())) {
            routerDef.remove(node.getName());
        }
    }

    public VWRouterNode getSavedRouter(String name) {
        VWRouterNode savedRouter = null;
        Hashtable routerDef = (Hashtable)this.m_savedRouters.get(this.m_rmiPort.toString());
        if (routerDef != null && routerDef.containsKey(name)) {
            savedRouter = (VWRouterNode)routerDef.get(name);
        }
        return savedRouter;
    }

    private void addSavedRouters() {
        Hashtable routers = (Hashtable)this.m_savedRouters.get(this.m_rmiPort.toString());
        VWRouterNode router = null;
        if (routers != null) {
            Enumeration e = routers.elements();
            while (e.hasMoreElements()) {
                router = (VWRouterNode)e.nextElement();
                if (router == null) continue;
                this.addRouterNode(router);
            }
        }
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ROUTERDEF_INDENT = "\t\t";
        theBuffer.append("\t<RouterAdminNode Port=\"" + this.m_rmiPort.toString() + "\">\n");
        Enumeration e = this.m_savedRouters.keys();
        while (e.hasMoreElements()) {
            String port = (String)e.nextElement();
            Hashtable routers = (Hashtable)this.m_savedRouters.get(port);
            theBuffer.append(ROUTERDEF_INDENT + "<RouterDefinition Port=\"" + port + "\">\n");
            if (routers != null) {
                Enumeration e2 = routers.elements();
                while (e2.hasMoreElements()) {
                    VWRouterNode routerNode = (VWRouterNode)e2.nextElement();
                    if (!routerNode.saveXML()) continue;
                    routerNode.toXML(theBuffer);
                }
            }
            theBuffer.append(ROUTERDEF_INDENT + "</RouterDefinition>\n");
        }
        theBuffer.append("\t</RouterAdminNode>\n");
    }

    private void fromXML(VWTaskXMLHandler xmlHandler) {
        Node[] definitionNodes;
        if (xmlHandler == null) {
            return;
        }
        Node routerAdminNode = VWTaskXMLHandler.getNodeNamed(xmlHandler.getRootNode(), XML_NODE_NAME);
        if (routerAdminNode == null || routerAdminNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)routerAdminNode;
        if (ele.getAttributeNode("Port") != null) {
            try {
                this.m_rmiPort = new Integer(ele.getAttribute("Port"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if ((definitionNodes = VWTaskXMLHandler.getNodesNamed(routerAdminNode, "RouterDefinition")) != null) {
            for (int i = 0; i < definitionNodes.length; ++i) {
                Element definitionElement = (Element)definitionNodes[i];
                String sRouterDefPort = definitionElement.getAttribute("Port");
                if (sRouterDefPort == null) continue;
                try {
                    int iRouterDefPort = Integer.parseInt(sRouterDefPort);
                    Hashtable routerDef = this.parseXMLRouterDefinition(definitionNodes[i], iRouterDefPort);
                    if (routerDef == null) continue;
                    this.m_savedRouters.put(sRouterDefPort, routerDef);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private Hashtable parseXMLRouterDefinition(Node node, int port) {
        Hashtable<String, VWRouterNode> routers = new Hashtable<String, VWRouterNode>();
        NodeList childNodes = node.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node aNode = childNodes.item(i);
                if (!aNode.getNodeName().equals("Router")) continue;
                VWRouterNode routerNode = null;
                try {
                    routerNode = new VWRouterNode(aNode, port);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (routerNode == null) continue;
                routers.put(routerNode.getName(), routerNode);
            }
        }
        if (routers.size() > 0) {
            return routers;
        }
        return null;
    }

    protected boolean isRouterNameInUse(String name) {
        VWTaskBaseNode[] nodes = this.getRootNode().findChildNodes(5, name, true);
        return nodes != null;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   17 May 2006 08:21:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ctimbreza  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.28  $";
    }
}

